<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_user'])) {
        $id = (int)$_POST['id'];
        $full_name = sanitize($_POST['full_name']);
        $mobile = sanitize($_POST['mobile']);
        $country = sanitize($_POST['country']);
        $status = $_POST['status'];

        $stmt = $db->prepare('UPDATE users SET full_name = ?, mobile = ?, country = ?, status = ? WHERE id = ?');
        if ($stmt->execute([$full_name, $mobile, $country, $status, $id])) {
            $message = 'User updated successfully!';
        } else {
            $message = 'Error updating user.';
        }
    } elseif (isset($_POST['adjust_balance'])) {
        $id = (int)$_POST['id'];
        $amount = (float)$_POST['amount'];
        $action = $_POST['balance_action'];

        if ($action === 'add') {
            $stmt = $db->prepare('UPDATE users SET balance = balance + ? WHERE id = ?');
        } elseif ($action === 'debit') {
            $stmt = $db->prepare('UPDATE users SET balance = balance - ? WHERE id = ?');
        }

        if ($stmt->execute([$amount, $id])) {
            $message = 'Balance adjusted successfully!';
        } else {
            $message = 'Error adjusting balance.';
        }
    }
}

// Get all users
$stmt = $db->query('SELECT * FROM users ORDER BY created_at DESC');
$users = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-12">
        <h1>User Management</h1>
        <?php if ($message): ?>
            <div class="alert alert-info"><?php echo $message; ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5>All Users</h5>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Full Name</th>
                            <th>Balance</th>
                            <th>Status</th>
                            <th>Joined</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                            <td><?php echo htmlspecialchars($user['full_name'] ?: 'N/A'); ?></td>
                            <td>$<?php echo number_format($user['balance'], 2); ?></td>
                            <td><?php echo ucfirst($user['status']); ?></td>
                            <td><?php echo date('Y-m-d', strtotime($user['created_at'])); ?></td>
                            <td>
                                <button class="btn btn-sm btn-warning" onclick="editUser(<?php echo $user['id']; ?>)">Edit</button>
                                <button class="btn btn-sm btn-info" onclick="adjustBalance(<?php echo $user['id']; ?>)">Balance</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Edit User Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit User</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" name="full_name" id="edit_full_name" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Mobile</label>
                        <input type="text" name="mobile" id="edit_mobile" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Country</label>
                        <input type="text" name="country" id="edit_country" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                            <option value="banned">Banned</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="update_user" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Adjust Balance Modal -->
<div class="modal fade" id="balanceModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Adjust Balance</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <input type="hidden" name="id" id="balance_id">
                    <div class="form-group">
                        <label>Amount</label>
                        <input type="number" step="0.01" name="amount" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Action</label>
                        <select name="balance_action" class="form-control">
                            <option value="add">Add to Balance</option>
                            <option value="debit">Debit from Balance</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="adjust_balance" class="btn btn-primary">Adjust Balance</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editUser(id) {
    window.location.href = '?edit=' + id;
}

function adjustBalance(id) {
    document.getElementById('balance_id').value = id;
    $('#balanceModal').modal('show');
}
</script>

<?php
if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    $stmt = $db->prepare('SELECT * FROM users WHERE id = ?');
    $stmt->execute([$edit_id]);
    $edit_user = $stmt->fetch();
    if ($edit_user) {
        echo "<script>
        document.getElementById('edit_id').value = '{$edit_user['id']}';
        document.getElementById('edit_full_name').value = '{$edit_user['full_name']}';
        document.getElementById('edit_mobile').value = '{$edit_user['mobile']}';
        document.getElementById('edit_country').value = '{$edit_user['country']}';
        document.getElementById('edit_status').value = '{$edit_user['status']}';
        $('#editModal').modal('show');
        </script>";
    }
}
?>

<?php include 'footer.php'; ?>