<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle approve/reject
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)$_POST['id'];
    $action = $_POST['action'];

    if ($action === 'approve') {
        $status = 'approved';
        // Update user balance if approving
        $stmt = $db->prepare('SELECT * FROM deposits WHERE id = ?');
        $stmt->execute([$id]);
        $deposit = $stmt->fetch();
        if ($deposit) {
            $stmt = $db->prepare('UPDATE users SET balance = balance + ? WHERE id = ?');
            $stmt->execute([$deposit['amount'], $deposit['user_id']]);
        }
    } elseif ($action === 'reject') {
        $status = 'rejected';
    }

    $stmt = $db->prepare('UPDATE deposits SET status = ? WHERE id = ?');
    if ($stmt->execute([$status, $id])) {
        $message = 'Deposit ' . $status . ' successfully!';
    } else {
        $message = 'Error updating deposit.';
    }
}

// Get all deposits
$stmt = $db->query('SELECT d.*, u.username, u.email FROM deposits d JOIN users u ON d.user_id = u.id ORDER BY d.date DESC');
$deposits = $stmt->fetchAll();
?>

<!-- Page Header -->
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-history"></i> Deposit History</h2>
                <p class="text-muted">Review and manage all deposit transactions</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if ($message): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success fade-in">
            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Deposits Table -->
<div class="row">
    <div class="col-12">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-list"></i> All Deposits (<?php echo count($deposits); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-user"></i> User</th>
                                <th><i class="fas fa-dollar-sign"></i> Amount</th>
                                <th><i class="fas fa-wallet"></i> Wallet Type</th>
                                <th><i class="fas fa-hashtag"></i> TX Hash</th>
                                <th><i class="fas fa-circle"></i> Status</th>
                                <th><i class="fas fa-calendar"></i> Date</th>
                                <th><i class="fas fa-cogs"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($deposits)): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">
                                    <i class="fas fa-info-circle"></i> No deposits found.
                                </td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($deposits as $deposit): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($deposit['username']); ?></strong><br>
                                        <small class="text-muted"><?php echo htmlspecialchars($deposit['email']); ?></small>
                                    </td>
                                    <td><strong>$<?php echo number_format($deposit['amount'], 2); ?></strong></td>
                                    <td><?php echo htmlspecialchars($deposit['wallet_type']); ?></td>
                                    <td>
                                        <?php if ($deposit['tx_hash']): ?>
                                            <span class="text-monospace small"><?php echo htmlspecialchars(substr($deposit['tx_hash'], 0, 20)); ?>...</span>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php
                                            echo $deposit['status'] === 'approved' ? 'success' :
                                                 ($deposit['status'] === 'rejected' ? 'danger' : 'warning');
                                        ?>">
                                            <?php echo ucfirst($deposit['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('M d, Y H:i', strtotime($deposit['date'])); ?></td>
                                    <td>
                                        <?php if ($deposit['status'] === 'pending'): ?>
                                        <form method="post" style="display: inline-block; margin-right: 5px;">
                                            <input type="hidden" name="id" value="<?php echo $deposit['id']; ?>">
                                            <input type="hidden" name="action" value="approve">
                                            <button type="submit" class="btn btn-success btn-sm">
                                                <i class="fas fa-check"></i> Approve
                                            </button>
                                        </form>
                                        <form method="post" style="display: inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $deposit['id']; ?>">
                                            <input type="hidden" name="action" value="reject">
                                            <button type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-times"></i> Reject
                                            </button>
                                        </form>
                                        <?php else: ?>
                                            <span class="text-muted">No actions</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
