<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_wallet'])) {
        $name = sanitize($_POST['name']);
        $address = sanitize($_POST['address']);
        $image = '';

        // Handle image upload
        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../auth/user/assets/img/wallets/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $image_name = time() . '_' . basename($_FILES['image']['name']);
            $image_path = $upload_dir . $image_name;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $image_path)) {
                $image = 'wallets/' . $image_name;
            }
        }

        $stmt = $db->prepare('INSERT INTO wallets (name, address, image) VALUES (?, ?, ?)');
        if ($stmt->execute([$name, $address, $image])) {
            $message = 'Wallet added successfully!';
        } else {
            $message = 'Error adding wallet.';
        }
    } elseif (isset($_POST['edit_wallet'])) {
        $id = (int)$_POST['id'];
        $name = sanitize($_POST['name']);
        $address = sanitize($_POST['address']);
        $status = $_POST['status'];
        $image = sanitize($_POST['current_image']);

        // Handle image upload
        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../auth/user/assets/img/wallets/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $image_name = time() . '_' . basename($_FILES['image']['name']);
            $image_path = $upload_dir . $image_name;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $image_path)) {
                $image = 'wallets/' . $image_name;
            }
        }

        $stmt = $db->prepare('UPDATE wallets SET name = ?, address = ?, image = ?, status = ? WHERE id = ?');
        if ($stmt->execute([$name, $address, $image, $status, $id])) {
            $message = 'Wallet updated successfully!';
        } else {
            $message = 'Error updating wallet.';
        }
    } elseif (isset($_POST['delete_wallet'])) {
        $id = (int)$_POST['id'];
        $stmt = $db->prepare('DELETE FROM wallets WHERE id = ?');
        if ($stmt->execute([$id])) {
            $message = 'Wallet deleted successfully!';
        } else {
            $message = 'Error deleting wallet.';
        }
    }
}

// Get all wallets
$stmt = $db->query('SELECT * FROM wallets ORDER BY id DESC');
$wallets = $stmt->fetchAll();
?>

<!-- Page Header -->
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-wallet"></i> Wallet Management</h2>
                <p class="text-muted">Configure deposit wallet addresses and settings</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if ($message): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success fade-in">
            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Add Wallet Form -->
<div class="row">
    <div class="col-md-4">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-plus"></i> Add New Wallet</h5>
            </div>
            <div class="card-body">
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-tag"></i> Wallet Name</label>
                        <input type="text" name="name" class="form-control" placeholder="e.g., Bitcoin" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-address-card"></i> Wallet Address</label>
                        <input type="text" name="address" class="form-control" placeholder="Enter wallet address" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-image"></i> Wallet Logo (Optional)</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                        <small class="text-muted">Upload a logo for this wallet type</small>
                    </div>
                    <button type="submit" name="add_wallet" class="btn btn-primary w-100">
                        <i class="fas fa-plus"></i> Add Wallet
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Wallets Table -->
    <div class="col-md-8">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-list"></i> Existing Wallets (<?php echo count($wallets); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-image"></i> Logo</th>
                                <th><i class="fas fa-tag"></i> Name</th>
                                <th><i class="fas fa-address-card"></i> Address</th>
                                <th><i class="fas fa-circle"></i> Status</th>
                                <th><i class="fas fa-cogs"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($wallets)): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted">
                                    <i class="fas fa-info-circle"></i> No wallets configured yet. Add one using the form on the left.
                                </td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($wallets as $wallet): ?>
                                <tr>
                                    <td>
                                        <?php if ($wallet['image']): ?>
                                            <img src="../auth/user/assets/img/<?php echo $wallet['image']; ?>" alt="Wallet" style="width: 40px; height: 40px; object-fit: cover; border-radius: 6px;">
                                        <?php else: ?>
                                            <div style="width: 40px; height: 40px; background: var(--secondary-color); border-radius: 6px; display: flex; align-items: center; justify-content: center; color: white;">
                                                <i class="fas fa-wallet"></i>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td><strong><?php echo htmlspecialchars($wallet['name']); ?></strong></td>
                                    <td>
                                        <span class="text-monospace small"><?php echo htmlspecialchars(substr($wallet['address'], 0, 20)); ?>...</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo $wallet['status'] === 'active' ? 'success' : 'warning'; ?>">
                                            <?php echo ucfirst($wallet['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-warning btn-sm" onclick="editWallet(<?php echo $wallet['id']; ?>)">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <form method="post" style="display: inline-block; margin-left: 5px;">
                                            <input type="hidden" name="id" value="<?php echo $wallet['id']; ?>">
                                            <button type="submit" name="delete_wallet" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this wallet?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Wallet Modal -->
<div class="modal" id="editModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit"></i> Edit Wallet</h5>
                <button type="button" class="modal-close" onclick="closeModal('editModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="post" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <input type="hidden" name="current_image" id="edit_current_image">
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-tag"></i> Wallet Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-address-card"></i> Wallet Address</label>
                        <input type="text" name="address" id="edit_address" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-image"></i> Logo (leave empty to keep current)</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-circle"></i> Status</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Cancel</button>
                    <button type="submit" name="edit_wallet" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Modal functions (defined in footer.php but ensuring they're available)
function openModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) modal.classList.add('show');
}

function closeModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) modal.classList.remove('show');
}

function editWallet(id) {
    window.location.href = '?edit=' + id;
}

// Handle edit modal on page load
document.addEventListener('DOMContentLoaded', function() {
    <?php if (isset($_GET['edit'])): ?>
        <?php
        $edit_id = (int)$_GET['edit'];
        $stmt = $db->prepare('SELECT * FROM wallets WHERE id = ?');
        $stmt->execute([$edit_id]);
        $edit_wallet = $stmt->fetch();
        if ($edit_wallet):
        ?>
        document.getElementById('edit_id').value = '<?php echo $edit_wallet['id']; ?>';
        document.getElementById('edit_name').value = '<?php echo addslashes($edit_wallet['name']); ?>';
        document.getElementById('edit_address').value = '<?php echo addslashes($edit_wallet['address']); ?>';
        document.getElementById('edit_current_image').value = '<?php echo addslashes($edit_wallet['image']); ?>';
        document.getElementById('edit_status').value = '<?php echo $edit_wallet['status']; ?>';
        openModal('editModal');
        <?php endif; ?>
    <?php endif; ?>
});
</script>

<?php include 'footer.php'; ?>
