<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$message = '';
$db = getDB();

// Get available wallets
$stmt = $db->query('SELECT * FROM wallets WHERE status = "active" ORDER BY name');
$wallets = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = (float)$_POST['amount'];
    $wallet_type = sanitize($_POST['wallet_type']);
    $wallet_address = sanitize($_POST['wallet_address']);

    if (empty($amount) || empty($wallet_type) || empty($wallet_address)) {
        $message = 'Please fill all fields';
    } elseif ($amount < 10) { // Minimum withdrawal
        $message = 'Minimum withdrawal amount is $10';
    } elseif ($amount > $user['balance']) {
        $message = 'Insufficient balance. Your current balance is $' . number_format($user['balance'], 2);
    } else {
        // Insert withdrawal request
        $stmt = $db->prepare('INSERT INTO withdrawals (user_id, amount, wallet_type, wallet_address) VALUES (?, ?, ?, ?)');
        if ($stmt->execute([$user['id'], $amount, $wallet_type, $wallet_address])) {
            $message = 'Withdrawal request submitted successfully! It will be processed within 24 hours.';
        } else {
            $message = 'Error submitting withdrawal request.';
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdraw Funds - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Withdraw Funds</h3>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <strong>Available Balance:</strong> $<?php echo number_format($user['balance'], 2); ?><br>
                            <strong>Minimum Withdrawal:</strong> $10.00
                        </div>

                        <?php if ($message): ?>
                            <div class="alert alert-info"><?php echo $message; ?></div>
                        <?php endif; ?>

                        <form method="post">
                            <div class="form-group">
                                <label>Withdrawal Amount ($)</label>
                                <input type="number" step="0.01" name="amount" class="form-control" required min="10" max="<?php echo $user['balance']; ?>">
                            </div>

                            <div class="form-group">
                                <label>Select Wallet Type</label>
                                <select name="wallet_type" class="form-control" required>
                                    <option value="">Choose wallet type...</option>
                                    <?php foreach ($wallets as $wallet): ?>
                                        <option value="<?php echo htmlspecialchars($wallet['name']); ?>"><?php echo htmlspecialchars($wallet['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Your Wallet Address</label>
                                <input type="text" name="wallet_address" class="form-control" required placeholder="Enter your wallet address">
                                <small class="form-text text-muted">Make sure the address is correct. Withdrawals are irreversible.</small>
                            </div>

                            <button type="submit" class="btn btn-primary">Submit Withdrawal Request</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>