<?php
require_once 'config.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize($_POST['email']);

    if (empty($email)) {
        $message = 'Please enter your email';
    } else {
        $db = getDB();
        $stmt = $db->prepare('SELECT * FROM users WHERE email = ?');
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user) {
            // Generate reset token
            $reset_token = bin2hex(random_bytes(32));
            $reset_expiry = date('Y-m-d H:i:s', strtotime('+1 hour'));

            $stmt = $db->prepare('UPDATE users SET reset_token = ?, reset_expiry = ? WHERE id = ?');
            $stmt->execute([$reset_token, $reset_expiry, $user['id']]);

            // Send reset email
            $reset_link = SITE_URL . '/reset-password?token=' . $reset_token;
            $subject = 'Password Reset - ' . SITE_NAME;
            $message_body = "Click the link to reset your password: <a href='$reset_link'>$reset_link</a>";
            sendEmail($email, $subject, $message_body);

            $message = 'Password reset link sent to your email';
        } else {
            $message = 'Email not found';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body class="login-page">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-4">
                <div class="card mt-5">
                    <div class="card-header text-center">
                        <h3>Forgot Password</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-info"><?php echo $message; ?></div>
                        <?php endif; ?>
                        <form method="post">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">Send Reset Link</button>
                        </form>
                        <div class="text-center mt-3">
                            <a href="login">Back to Login</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>