<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $message = 'Please fill all fields';
    } elseif ($new_password !== $confirm_password) {
        $message = 'New passwords do not match';
    } elseif (!password_verify($current_password, $user['password'])) {
        $message = 'Current password is incorrect';
    } else {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $db = getDB();
        $stmt = $db->prepare('UPDATE users SET password = ? WHERE id = ?');
        if ($stmt->execute([$hashed_password, $user['id']])) {
            $message = 'Password changed successfully!';
        } else {
            $message = 'Error changing password.';
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Change Password - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3>Change Password</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-info"><?php echo $message; ?></div>
                        <?php endif; ?>

                        <form method="post">
                            <div class="form-group">
                                <label>Current Password</label>
                                <input type="password" name="current_password" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label>New Password</label>
                                <input type="password" name="new_password" class="form-control" required minlength="6">
                            </div>
                            <div class="form-group">
                                <label>Confirm New Password</label>
                                <input type="password" name="confirm_password" class="form-control" required minlength="6">
                            </div>
                            <button type="submit" class="btn btn-primary">Change Password</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>