<?php
include 'header.php';

$message = '';
$db = getDB();

// Get current settings
$stmt = $db->query('SELECT * FROM settings LIMIT 1');
$current_settings = $stmt->fetch();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $smtp_host = sanitize($_POST['smtp_host']);
    $smtp_port = (int)$_POST['smtp_port'];
    $smtp_user = sanitize($_POST['smtp_user']);
    $smtp_pass = $_POST['smtp_pass']; // Don't sanitize password
    $smtp_secure = $_POST['smtp_secure'];
    $site_name = sanitize($_POST['site_name']);
    $site_email = sanitize($_POST['site_email']);
    $site_url = sanitize($_POST['site_url']);

    if ($current_settings) {
        $stmt = $db->prepare('UPDATE settings SET smtp_host = ?, smtp_port = ?, smtp_user = ?, smtp_pass = ?, smtp_secure = ?, site_name = ?, site_email = ?, site_url = ? WHERE id = ?');
        $result = $stmt->execute([$smtp_host, $smtp_port, $smtp_user, $smtp_pass, $smtp_secure, $site_name, $site_email, $site_url, $current_settings['id']]);
    } else {
        $stmt = $db->prepare('INSERT INTO settings (smtp_host, smtp_port, smtp_user, smtp_pass, smtp_secure, site_name, site_email, site_url) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
        $result = $stmt->execute([$smtp_host, $smtp_port, $smtp_user, $smtp_pass, $smtp_secure, $site_name, $site_email, $site_url]);
    }

    if ($result) {
        $message = 'Settings updated successfully!';
        // Refresh settings
        $stmt = $db->query('SELECT * FROM settings LIMIT 1');
        $current_settings = $stmt->fetch();
    } else {
        $message = 'Error updating settings.';
    }
}
?>

<!-- Page Header -->
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-cog"></i> Settings</h2>
                <p class="text-muted">Configure application settings and preferences</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if ($message): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success fade-in">
            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Settings Form -->
<div class="row">
    <div class="col-md-8">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-sliders-h"></i> Application Settings</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label"><i class="fas fa-building"></i> Site Name</label>
                                <input type="text" name="site_name" class="form-control" value="<?php echo htmlspecialchars($current_settings['site_name'] ?? ''); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label"><i class="fas fa-envelope"></i> Site Email</label>
                                <input type="email" name="site_email" class="form-control" value="<?php echo htmlspecialchars($current_settings['site_email'] ?? ''); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-globe"></i> Site URL</label>
                        <input type="url" name="site_url" class="form-control" value="<?php echo htmlspecialchars($current_settings['site_url'] ?? ''); ?>" placeholder="https://example.com" required>
                    </div>

                    <h5 class="mt-4 mb-3"><i class="fas fa-mail-bulk"></i> SMTP Settings</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">SMTP Host</label>
                                <input type="text" name="smtp_host" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_host'] ?? ''); ?>" placeholder="smtp.gmail.com">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">SMTP Port</label>
                                <input type="number" name="smtp_port" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_port'] ?? ''); ?>" placeholder="587">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">SMTP Username</label>
                                <input type="text" name="smtp_user" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_user'] ?? ''); ?>" placeholder="your-email@gmail.com">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">SMTP Password</label>
                                <input type="password" name="smtp_pass" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_pass'] ?? ''); ?>" placeholder="your-password">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label">SMTP Security</label>
                        <select name="smtp_secure" class="form-control">
                            <option value="tls" <?php echo ($current_settings['smtp_secure'] ?? '') === 'tls' ? 'selected' : ''; ?>>TLS</option>
                            <option value="ssl" <?php echo ($current_settings['smtp_secure'] ?? '') === 'ssl' ? 'selected' : ''; ?>>SSL</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-question-circle"></i> Help</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong><i class="fas fa-building"></i> Site Name:</strong>
                    <p class="text-muted small">The name of your application that appears in emails and the interface.</p>
                </div>
                <div class="mb-3">
                    <strong><i class="fas fa-envelope"></i> Site Email:</strong>
                    <p class="text-muted small">The email address used for sending notifications and system messages.</p>
                </div>
                <div class="mb-3">
                    <strong><i class="fas fa-mail-bulk"></i> SMTP Settings:</strong>
                    <p class="text-muted small">Configure these to enable email sending. For Gmail, use smtp.gmail.com, port 587, TLS.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Withdrawal Methods Management -->
<div class="row">
    <div class="col-12">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-money-bill-wave"></i> Withdrawal Methods Management</h5>
            </div>
            <div class="card-body">
                <!-- Add New Method Form -->
                <form method="post" class="mb-4">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="form-label">Method Name</label>
                                <input type="text" name="method_name" class="form-control" placeholder="e.g., Bank Transfer" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Status</label>
                                <select name="method_status" class="form-control">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" name="add_method" class="btn btn-success w-100">
                                <i class="fas fa-plus"></i> Add Method
                            </button>
                        </div>
                    </div>
                </form>

                <?php
                // Handle add method
                if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_method'])) {
                    $method_name = sanitize($_POST['method_name']);
                    $method_status = $_POST['method_status'];

                    $stmt = $db->prepare('INSERT INTO withdrawal_methods (name, status) VALUES (?, ?)');
                    if ($stmt->execute([$method_name, $method_status])) {
                        $message = 'Withdrawal method added successfully!';
                    } else {
                        $message = 'Error adding method.';
                    }
                }

                // Handle status change
                if (isset($_GET['toggle']) && isset($_GET['id'])) {
                    $id = (int)$_GET['id'];
                    $stmt = $db->prepare('SELECT status FROM withdrawal_methods WHERE id = ?');
                    $stmt->execute([$id]);
                    $current = $stmt->fetch()['status'];
                    $new_status = $current === 'active' ? 'inactive' : 'active';

                    $stmt = $db->prepare('UPDATE withdrawal_methods SET status = ? WHERE id = ?');
                    $stmt->execute([$new_status, $id]);
                    redirect('settings.php');
                }

                // Handle delete
                if (isset($_GET['delete']) && isset($_GET['id'])) {
                    $id = (int)$_GET['id'];
                    $stmt = $db->prepare('DELETE FROM withdrawal_methods WHERE id = ?');
                    $stmt->execute([$id]);
                    redirect('settings.php');
                }

                // Get all methods
                $stmt = $db->query('SELECT * FROM withdrawal_methods ORDER BY name');
                $methods = $stmt->fetchAll();
                ?>

                <!-- Methods Table -->
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-tag"></i> Method Name</th>
                                <th><i class="fas fa-circle"></i> Status</th>
                                <th><i class="fas fa-calendar"></i> Created</th>
                                <th><i class="fas fa-cogs"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($methods)): ?>
                            <tr>
                                <td colspan="4" class="text-center text-muted">
                                    <i class="fas fa-info-circle"></i> No withdrawal methods found. Add one above.
                                </td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($methods as $method): ?>
                                <tr>
                                    <td><strong><?php echo htmlspecialchars($method['name']); ?></strong></td>
                                    <td>
                                        <span class="badge badge-<?php echo $method['status'] === 'active' ? 'success' : 'warning'; ?>">
                                            <?php echo ucfirst($method['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('M d, Y', strtotime($method['created_at'])); ?></td>
                                    <td>
                                        <a href="?toggle&id=<?php echo $method['id']; ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-toggle-on"></i> Toggle
                                        </a>
                                        <a href="?delete&id=<?php echo $method['id']; ?>"
                                           onclick="return confirm('Are you sure you want to delete this method?')" class="btn btn-danger btn-sm">
                                            <i class="fas fa-trash"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
