<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_plan'])) {
        $name = sanitize($_POST['name']);
        $min_amount = (float)$_POST['min_amount'];
        $max_amount = (float)$_POST['max_amount'];
        $roi = (float)$_POST['roi'];
        $duration = (int)$_POST['duration'];

        $stmt = $db->prepare('INSERT INTO investment_plans (name, min_amount, max_amount, roi, duration) VALUES (?, ?, ?, ?, ?)');
        if ($stmt->execute([$name, $min_amount, $max_amount, $roi, $duration])) {
            $message = 'Investment plan added successfully!';
        } else {
            $message = 'Error adding plan.';
        }
    } elseif (isset($_POST['edit_plan'])) {
        $id = (int)$_POST['id'];
        $name = sanitize($_POST['name']);
        $min_amount = (float)$_POST['min_amount'];
        $max_amount = (float)$_POST['max_amount'];
        $roi = (float)$_POST['roi'];
        $duration = (int)$_POST['duration'];
        $status = $_POST['status'];

        $stmt = $db->prepare('UPDATE investment_plans SET name = ?, min_amount = ?, max_amount = ?, roi = ?, duration = ?, status = ? WHERE id = ?');
        if ($stmt->execute([$name, $min_amount, $max_amount, $roi, $duration, $status, $id])) {
            $message = 'Investment plan updated successfully!';
        } else {
            $message = 'Error updating plan.';
        }
    } elseif (isset($_POST['delete_plan'])) {
        $id = (int)$_POST['id'];
        $stmt = $db->prepare('DELETE FROM investment_plans WHERE id = ?');
        if ($stmt->execute([$id])) {
            $message = 'Investment plan deleted successfully!';
        } else {
            $message = 'Error deleting plan.';
        }
    }
}

// Get all plans
$stmt = $db->query('SELECT * FROM investment_plans ORDER BY id DESC');
$plans = $stmt->fetchAll();
?>

<!-- Page Header -->
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-chart-line"></i> Investment Plans</h2>
                <p class="text-muted">Create and manage investment plans for users</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if ($message): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success fade-in">
            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Add Plan Form -->
<div class="row">
    <div class="col-md-4">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-plus"></i> Add New Plan</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-tag"></i> Plan Name</label>
                        <input type="text" name="name" class="form-control" placeholder="e.g., Bronze Plan" required>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label class="form-label"><i class="fas fa-dollar-sign"></i> Min Amount</label>
                                <input type="number" step="0.01" name="min_amount" class="form-control" placeholder="100" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="form-label"><i class="fas fa-dollar-sign"></i> Max Amount</label>
                                <input type="number" step="0.01" name="max_amount" class="form-control" placeholder="1000" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-percentage"></i> ROI (%)</label>
                        <input type="number" step="0.01" name="roi" class="form-control" placeholder="5.0" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-clock"></i> Duration (hours)</label>
                        <input type="number" name="duration" class="form-control" placeholder="24" required>
                    </div>
                    <button type="submit" name="add_plan" class="btn btn-primary w-100">
                        <i class="fas fa-plus"></i> Add Plan
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Plans Table -->
    <div class="col-md-8">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-list"></i> Existing Plans (<?php echo count($plans); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-tag"></i> Plan Name</th>
                                <th><i class="fas fa-dollar-sign"></i> Amount Range</th>
                                <th><i class="fas fa-percentage"></i> ROI</th>
                                <th><i class="fas fa-clock"></i> Duration</th>
                                <th><i class="fas fa-circle"></i> Status</th>
                                <th><i class="fas fa-cogs"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($plans)): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    <i class="fas fa-info-circle"></i> No investment plans created yet. Add one using the form on the left.
                                </td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($plans as $plan): ?>
                                <tr>
                                    <td><strong><?php echo htmlspecialchars($plan['name']); ?></strong></td>
                                    <td>$<?php echo number_format($plan['min_amount'], 2); ?> - $<?php echo number_format($plan['max_amount'], 2); ?></td>
                                    <td><span class="text-success"><strong><?php echo $plan['roi']; ?>%</strong></span></td>
                                    <td><?php echo $plan['duration']; ?> hours</td>
                                    <td>
                                        <span class="badge badge-<?php echo $plan['status'] === 'active' ? 'success' : 'warning'; ?>">
                                            <?php echo ucfirst($plan['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-warning btn-sm" onclick="editPlan(<?php echo $plan['id']; ?>)">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <form method="post" style="display: inline-block; margin-left: 5px;">
                                            <input type="hidden" name="id" value="<?php echo $plan['id']; ?>">
                                            <button type="submit" name="delete_plan" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this investment plan?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Plan Modal -->
<div class="modal" id="editModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit"></i> Edit Investment Plan</h5>
                <button type="button" class="modal-close" onclick="closeModal('editModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-tag"></i> Plan Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label class="form-label"><i class="fas fa-dollar-sign"></i> Min Amount</label>
                                <input type="number" step="0.01" name="min_amount" id="edit_min_amount" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="form-label"><i class="fas fa-dollar-sign"></i> Max Amount</label>
                                <input type="number" step="0.01" name="max_amount" id="edit_max_amount" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-percentage"></i> ROI (%)</label>
                        <input type="number" step="0.01" name="roi" id="edit_roi" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-clock"></i> Duration (hours)</label>
                        <input type="number" name="duration" id="edit_duration" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-circle"></i> Status</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Cancel</button>
                    <button type="submit" name="edit_plan" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Modal functions (defined in footer.php but ensuring they're available)
function openModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) modal.classList.add('show');
}

function closeModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) modal.classList.remove('show');
}

function editPlan(id) {
    window.location.href = '?edit=' + id;
}

// Handle edit modal on page load
document.addEventListener('DOMContentLoaded', function() {
    <?php if (isset($_GET['edit'])): ?>
        <?php
        $edit_id = (int)$_GET['edit'];
        $stmt = $db->prepare('SELECT * FROM investment_plans WHERE id = ?');
        $stmt->execute([$edit_id]);
        $edit_plan = $stmt->fetch();
        if ($edit_plan):
        ?>
        document.getElementById('edit_id').value = '<?php echo $edit_plan['id']; ?>';
        document.getElementById('edit_name').value = '<?php echo addslashes($edit_plan['name']); ?>';
        document.getElementById('edit_min_amount').value = '<?php echo $edit_plan['min_amount']; ?>';
        document.getElementById('edit_max_amount').value = '<?php echo $edit_plan['max_amount']; ?>';
        document.getElementById('edit_roi').value = '<?php echo $edit_plan['roi']; ?>';
        document.getElementById('edit_duration').value = '<?php echo $edit_plan['duration']; ?>';
        document.getElementById('edit_status').value = '<?php echo $edit_plan['status']; ?>';
        openModal('editModal');
        <?php endif; ?>
    <?php endif; ?>
});
</script>

<?php include 'footer.php'; ?>
